/*
 * Decompiled with CFR 0.152.
 */
package com.florianhaber.camlog.cst;

import antlr.ANTLRException;
import com.florianhaber.camlog.ast.AST;
import com.florianhaber.camlog.ast.TYP;
import com.florianhaber.camlog.cam.CCC;
import com.florianhaber.camlog.cam.DOM;
import com.florianhaber.camlog.cst.CST;
import com.florianhaber.camlog.cst.CTX;
import com.florianhaber.camlog.utl.UTL;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class LST
extends CST {
    PrintWriter output;
    List lstOpts;

    public LST(CTX cTX, UTL.Options options, PrintWriter printWriter) {
        super(cTX, options);
        this.output = printWriter;
        this.cam.errout = printWriter;
        this.lstOpts = Arrays.asList(UTL.split(options.value("lst"), ','));
    }

    public void parse() {
        try {
            super.parse();
        }
        catch (ANTLRException aNTLRException) {
            this.output.println("\nSYNTAX ERROR DETECTED IN PARSING:\n   " + (Object)((Object)aNTLRException));
            throw new CST.ProcessedException((Exception)((Object)aNTLRException));
        }
        if (!this.par.errors.equals("")) {
            this.output.print("\nSYNTAX ERRORS DETECTED IN PARSING:\n   " + this.par.errors);
            throw new CST.ProcessedException();
        }
        if (this.lstOpts.contains("ast")) {
            this.output.println("\nLAMBDA TERM CODE:\n   " + this.show(this.ast));
        }
    }

    public void compileTypes() {
        try {
            super.compileTypes();
            if ((this.lstOpts.contains("ast") || this.lstOpts.contains("tast")) && !this.globalTypeTable.isEmpty()) {
                this.output.println("\nTYPE DEFINITIONS:");
                if (this.options.check("pp")) {
                    this.output.print("   ");
                    this.listTypes(this.output, "\n   ");
                } else {
                    this.listTypes(this.output);
                }
            }
        }
        catch (TYP.ApplicationException applicationException) {
            this.output.println("\nERROR IN TYPE EXPRESSION:\n   " + applicationException);
            throw new CST.ProcessedException(applicationException);
        }
    }

    public void resolveSymbols() {
        try {
            super.resolveSymbols();
        }
        catch (AST.ResolutionException resolutionException) {
            this.output.println("\nVARIABLE RESOLUTION ERROR:\n   " + resolutionException.toString());
            throw new CST.ProcessedException(resolutionException);
        }
    }

    public void typing() {
        try {
            super.typing();
            this.output.println("\nINFERED HINDLEY/MILNER PRINCIPAL TYPE:\n   " + this.show(this.typ.type));
        }
        catch (AST.TypingException typingException) {
            this.output.println("\nTYPING ERROR:\n   " + typingException);
            throw new CST.ProcessedException(typingException);
        }
        if (this.lstOpts.contains("tast")) {
            this.output.println("\nLAMBDA TERM CODE:\n   " + this.show(this.ast));
        }
    }

    public void compile() {
        super.compile();
        if (this.lstOpts.contains("ccc")) {
            this.output.println("\nCATEGORICAL COMBINATOR CODE:\n   " + this.show(this.ccc));
        }
    }

    public void assemble() {
        super.assemble();
        if (this.lstOpts.contains("asm")) {
            this.output.println("\nCAM ASSEMBLY LANGUAGE CODE:");
            this.asm.listing(this.output);
        }
    }

    private String show(Object object) {
        return this.options.check("pp") && object instanceof UTL.Prettyprint ? ((UTL.Prettyprint)object).toString("\n   ") : object.toString();
    }

    public void cccBytecode(String string) throws IOException {
        if (string.indexOf(46) < 0) {
            string = string + ".CCC";
        }
        try {
            super.cccBytecode(string);
            this.output.println("\nCOMBINATOR BYTECODE GENERATED: " + string);
        }
        catch (IOException iOException) {
            this.output.println("\nERROR IN CCC BYTECODE GENERATION (" + string + ")..\n   " + iOException);
        }
    }

    public void camBytecode(String string) {
        if (string.indexOf(46) < 0) {
            string = string + ".CAM";
        }
        try {
            super.camBytecode(string);
            this.output.println("\nCAM BYTECODE GENERATED: " + string);
        }
        catch (IOException iOException) {
            this.output.println("\nERROR IN CAM BYTECODE GENERATION (" + string + ")..\n   " + iOException);
        }
    }

    public void progBytecode(String string) throws IOException {
        if (string.indexOf(46) < 0) {
            string = string + (this.prog instanceof CCC.Closure ? ".CCC" : ".CAM");
        }
        try {
            super.progBytecode(string);
            this.output.println("\nCLOSURE BYTECODE GENERATED: " + string);
        }
        catch (IOException iOException) {
            this.output.println("\nERROR IN CLOSURE BYTECODE GENERATION (" + string + ")..\n   " + iOException);
        }
    }

    public Object cccEval(Object object) {
        System.gc();
        long l = System.currentTimeMillis();
        super.cccEval(object);
        this.output.println("\nCCC COMBINATOR EVALUATION / STRICT BETA REDUCTION" + (!this.options.check("det") ? " (" + -(l -= System.currentTimeMillis()) + "ms)" : "") + ":\n   " + (this.result != null ? this.show(this.result) : "GLOBAL FAILURE"));
        return this.result;
    }

    public Object invoke(Object object) {
        System.gc();
        long l = System.currentTimeMillis();
        try {
            super.invoke(object);
        }
        catch (DOM.InvokationException invokationException) {
            this.output.println("\nERROR IN " + UTL.className(this.prog) + " EXECUTION:\n   " + invokationException);
            throw new CST.ProcessedException(invokationException);
        }
        this.output.println("\nEXECUTION OF " + UTL.className(this.prog) + " / STRICT BETA REDUCTION" + (!this.options.check("det") ? " (" + -(l -= System.currentTimeMillis()) + "ms)" : "") + ":\n   " + (this.result != null ? this.show(this.result) : "GLOBAL FAILURE"));
        return this.result;
    }

    public Object reinvoke() {
        super.reinvoke();
        this.output.println("\nREINVOKATION OF " + UTL.className(this.prog) + " / STRICT BETA REDUCTION" + ":\n   " + (this.result != null ? this.show(this.result) : "GLOBAL FAILURE"));
        return this.result;
    }

    public Object debug(Object object) {
        super.debug(object);
        this.output.println("\nDEBUGGER EXECUTION OF " + UTL.className(this.prog) + " / STRICT BETA REDUCTION" + ":\n   " + (this.result != null ? this.show(this.result) : "GLOBAL FAILURE"));
        return this.result;
    }

    public Iterator tracker(Object object) {
        this.output.println("\nBACKTRACKING OF " + this.prog.getClass() + " / STRICT BETA REDUCTION");
        super.tracker(object);
        this.allResults = new Iterator(){
            private Iterator allResults;
            private int resno;
            {
                this.allResults = LST.this.allResults;
                this.resno = 0;
            }

            public boolean hasNext() {
                return this.allResults.hasNext();
            }

            public Object next() {
                Object e = this.allResults.next();
                LST.this.output.println("\nCAM EXECUTION / BACKTRACKED RESULT #" + this.resno++ + ":\n   " + LST.this.show(e));
                return e;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return this.allResults;
    }

    public void dumpRAM() {
        this.output.println("\nCAM MEMORY DUMP:");
        super.dumpRAM();
    }
}

