/*
 * Decompiled with CFR 0.152.
 */
package com.florianhaber.camlog.ast;

import com.florianhaber.camlog.utl.UTL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class TYP {
    private static Quantifier s = new Quantifier();
    public static Scheme TOP = new Scheme(s, new Ref(new Variable(s)));
    public static Ref One;
    public static Ref Zero;

    public static Ref Function(Ref ref, Ref ref2) {
        try {
            return new Ref(new Application(Constructor.Function, new Ref[]{ref, ref2}));
        }
        catch (ApplicationException applicationException) {
            throw new Error();
        }
    }

    public static Ref Product(Ref ref, Ref ref2) {
        try {
            return new Ref(new Application(Constructor.Product, new Ref[]{ref, ref2}));
        }
        catch (ApplicationException applicationException) {
            throw new Error();
        }
    }

    public static Ref Sum(Ref ref, Ref ref2) {
        try {
            return new Ref(new Application(Constructor.Sum, new Ref[]{ref, ref2}));
        }
        catch (ApplicationException applicationException) {
            throw new Error();
        }
    }

    static {
        try {
            One = new Ref(new Application(Constructor.One));
            Zero = new Ref(new Application(Constructor.Zero));
        }
        catch (ApplicationException applicationException) {
            // empty catch block
        }
    }

    public static class ApplicationException
    extends Exception {
        private Constructor fun;
        private Ref[] arg;

        ApplicationException(Constructor constructor, Ref[] refArray) {
            super("bad arity in type construction: " + constructor.name + "/" + constructor.arity + "\n" + "   application term '" + constructor.name + " " + Arrays.asList(refArray) + "'");
            this.fun = constructor;
            this.arg = refArray;
        }
    }

    public static class UnificationException
    extends Exception {
        Type lhs;
        Type rhs;

        UnificationException(Type type, Type type2, String string) {
            super("unification failure at:\n   " + type + " = " + type2 + "\n" + "   " + string);
            this.lhs = type;
            this.rhs = type2;
        }
    }

    public static class Constructor {
        protected String name;
        public int arity;
        public static Constructor One = new Constructor("1");
        public static Constructor Zero = new Constructor("0");
        public static Constructor Product = new Constructor("*", 2){

            public String toStringApp(UTL.Prettyprint[] prettyprintArray, String string) {
                return "(  " + prettyprintArray[0].toString(string + "   ") + string + ",  " + prettyprintArray[1].toString(string + "   ") + string + ")";
            }
        };
        public static Constructor Sum = new Constructor("+", 2){

            public String toStringApp(UTL.Prettyprint[] prettyprintArray, String string) {
                return "(  " + prettyprintArray[0].toString(string + "   ") + string + ";  " + prettyprintArray[1].toString(string + "   ") + string + ")";
            }
        };
        public static Constructor Function = new Constructor("->", 2){

            public String toStringApp(UTL.Prettyprint[] prettyprintArray, String string) {
                return "[  " + prettyprintArray[0].toString(string + "   ") + string + "-> " + prettyprintArray[1].toString(string + "   ") + string + "]";
            }
        };

        public Constructor(String string, int n) {
            this.name = string;
            this.arity = n;
        }

        public Constructor(String string) {
            this(string, 0);
        }

        public void compile(Map map, Map map2) throws ApplicationException {
        }

        public String toString() {
            return this.name + "/" + this.arity;
        }

        public String toStringApp(UTL.Prettyprint[] prettyprintArray, String string) {
            if (this.arity == 0) {
                return this.name;
            }
            String string2 = "(" + this.name + string;
            int n = 0;
            while (n < this.arity) {
                string2 = string2 + "   " + prettyprintArray[n].toString(string + "   ") + string;
                ++n;
            }
            return string2 + ")";
        }
    }

    public static class Quantifier
    extends HashSet {
        private int level;
        public static Quantifier EMPTY = new Quantifier(){

            public boolean add(Object object) {
                throw new Error("THIS CAN'T HAPPEN - " + object + " generated in scope EMPTY");
            }
        };

        public Quantifier() {
            this.level = 0;
        }

        public Quantifier(Quantifier quantifier) {
            this.level = quantifier.level + 1;
        }

        public boolean covers(Quantifier quantifier) {
            return this.level < quantifier.level;
        }

        public String toString() {
            String string = "";
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                string = string + (Type)iterator.next() + " ";
            }
            return "\\-/ " + string + ".";
        }

        public boolean contains(Variable variable) {
            return variable.scope() == this;
        }
    }

    public static class Scheme
    implements UTL.Prettyprint {
        public Quantifier universal;
        public Ref type;

        protected Scheme() {
            this.universal = Quantifier.EMPTY;
        }

        public Scheme(Quantifier quantifier, Ref ref) {
            this.universal = quantifier;
            this.type = ref;
        }

        public Ref instantiate(Quantifier quantifier) {
            HashMap hashMap = new HashMap();
            Collection collection = this.type.occurrences();
            collection.retainAll(this.universal);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                hashMap.put(iterator.next(), new Variable(quantifier));
            }
            return this.type.instantiate(hashMap);
        }

        public Scheme copy() {
            Quantifier quantifier = new Quantifier();
            return new Scheme(quantifier, this.instantiate(quantifier));
        }

        public boolean equivalent(Scheme scheme) {
            return this.type.equivalent(scheme.type, new HashMap());
        }

        public String toString() {
            return this.universal + " " + this.type;
        }

        public String toString(String string) {
            return this.universal + string + "   " + this.type.toString(string + "   ");
        }
    }

    public static class Ref
    extends Scheme
    implements UTL.Prettyprint {
        private Type value;

        public Ref(Type type) {
            this.type = this;
            this.assign(type);
        }

        void assign(Type type) {
            this.value = type;
            type.refer(this);
        }

        public boolean occurs(Variable variable) {
            return this.value.occurs(variable);
        }

        public void occurrences(Collection collection) {
            this.value.occurrences(collection);
        }

        public final Collection occurrences() {
            return this.value.occurrences();
        }

        public void unify(Ref ref) throws UnificationException {
            ref.value.unify(this.value);
        }

        Ref instantiate(Map map) {
            Type type = this.value.instantiate(map);
            return type == this.value ? this : new Ref(type);
        }

        boolean equivalent(Ref ref, Map map) {
            return this.value.equivalent(ref.value, map);
        }

        public String toString() {
            return this.value.toString();
        }

        public String toString(String string) {
            return this.value.toString(string);
        }
    }

    public static class Application
    extends Type {
        private Constructor fun;
        private Ref[] arg;

        public Application(Constructor constructor, Ref[] refArray) throws ApplicationException {
            if (constructor.arity != refArray.length) {
                throw new ApplicationException(constructor, refArray);
            }
            this.fun = constructor;
            this.arg = refArray;
        }

        public Application(Constructor constructor) throws ApplicationException {
            this(constructor, new Ref[0]);
        }

        public boolean occurs(Variable variable) {
            int n = 0;
            while (n < this.arg.length) {
                if (this.arg[n].occurs(variable)) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        public void occurrences(Collection collection) {
            int n = 0;
            while (n < this.arg.length) {
                this.arg[n].occurrences(collection);
                ++n;
            }
        }

        void unify_aux(Type type) throws UnificationException {
            if (type instanceof Application && this.fun == ((Application)type).fun) {
                int n = 0;
                while (n < this.arg.length) {
                    this.arg[n].unify(((Application)type).arg[n]);
                    ++n;
                }
            } else {
                throw new UnificationException(this, type, "type constructions do not match");
            }
        }

        Type instantiate(Map map) {
            Ref[] refArray = new Ref[this.arg.length];
            int n = 0;
            while (n < this.arg.length) {
                refArray[n] = this.arg[n].instantiate(map);
                ++n;
            }
            int n2 = 0;
            while (n2 < this.arg.length) {
                if (refArray[n2] != this.arg[n2]) {
                    try {
                        return new Application(this.fun, refArray);
                    }
                    catch (ApplicationException applicationException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
            return this;
        }

        public boolean equivalent_aux(Type type, Map map) {
            if (this.fun != ((Application)type).fun) {
                return false;
            }
            int n = 0;
            while (n < this.arg.length) {
                if (!this.arg[n].equivalent(((Application)type).arg[n], map)) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        public String toString(String string) {
            return this.fun.toStringApp(this.arg, string);
        }
    }

    public static class Variable
    extends Type {
        private String name;
        private ArrayList references = new ArrayList();
        private Quantifier scope;
        private static int fresh_counter = 0;

        public Variable(String string, Quantifier quantifier) {
            this.name = string;
            this.scope(quantifier);
        }

        protected void refer(Ref ref) {
            this.references.add(ref);
        }

        public Quantifier scope() {
            return this.scope;
        }

        private void scope(Quantifier quantifier) {
            quantifier.add(this);
            this.scope = quantifier;
        }

        public void substitute(Type type) {
            Iterator iterator = ((AbstractList)this.references).iterator();
            while (iterator.hasNext()) {
                ((Ref)iterator.next()).assign(type);
            }
            Iterator iterator2 = type.occurrences().iterator();
            while (iterator2.hasNext()) {
                Variable variable = (Variable)iterator2.next();
                if (!this.scope.covers(variable.scope)) continue;
                variable.scope.remove(variable);
                variable.scope(this.scope);
            }
            this.scope.remove(this);
        }

        public Variable(Quantifier quantifier) {
            this("nu_" + Integer.toString(fresh_counter++), quantifier);
        }

        public boolean occurs(Variable variable) {
            return this == variable;
        }

        public void occurrences(Collection collection) {
            collection.add(this);
        }

        public void unify(Type type) throws UnificationException {
            if (this == type) {
                return;
            }
            this.unify_aux(type);
        }

        void unify_aux(Type type) throws UnificationException {
            if (type.occurs(this)) {
                throw new UnificationException(this, type, "this equation made the occurs check snap into effect");
            }
            this.substitute(type);
        }

        Type instantiate(Map map) {
            Type type = (Type)map.get(this);
            return type == null ? this : type;
        }

        public boolean equivalent_aux(Type type, Map map) {
            if (map.containsKey(this)) {
                return map.get(this) == type;
            }
            if (map.containsValue(type)) {
                return false;
            }
            map.put(this, type);
            return true;
        }

        public String toString(String string) {
            return this.name;
        }
    }

    public static abstract class Type {
        protected void refer(Ref ref) {
        }

        public abstract boolean occurs(Variable var1);

        public final Collection occurrences() {
            HashSet hashSet = new HashSet();
            this.occurrences(hashSet);
            return hashSet;
        }

        public abstract void occurrences(Collection var1);

        public void unify(Type type) throws UnificationException {
            type.unify_aux(this);
        }

        abstract void unify_aux(Type var1) throws UnificationException;

        abstract Type instantiate(Map var1);

        public boolean equivalent(Type type, Map map) {
            return this.equals(type) || this.getClass().equals(type.getClass()) && this.equivalent_aux(type, map);
        }

        abstract boolean equivalent_aux(Type var1, Map var2);

        public String toString() {
            return UTL.compressWhitespace(this.toString(""));
        }

        public abstract String toString(String var1);
    }
}

