/*
 * Decompiled with CFR 0.152.
 */
package com.florianhaber.camlog;

import com.florianhaber.camlog.cam.CAM;
import com.florianhaber.camlog.cam.CCC;
import com.florianhaber.camlog.cam.DOM;
import com.florianhaber.camlog.res.STDrun;
import com.florianhaber.camlog.utl.UTL;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.util.Random;
import java.util.zip.GZIPInputStream;

public class CAMlogVM {
    public static void main(String[] stringArray) throws IOException {
        String string;
        UTL.Options options = new UTL.Options("");
        if ((stringArray = options.parseArgs(stringArray)).length <= 0) {
            System.err.print("CAMlog binary> ");
            string = new BufferedReader(new InputStreamReader(System.in)).readLine();
        } else {
            string = stringArray[0];
        }
        CAMlogVM.main(new GZIPInputStream(new FileInputStream(string)), stringArray.length <= 1 ? new PrintWriter(System.out, true) : new PrintWriter(new FileWriter(stringArray[1])), options);
        System.err.println("-CAMlog(VM) done-");
    }

    public static void main(InputStream inputStream, PrintWriter printWriter, UTL.Options options) throws IOException {
        block18: {
            try {
                printWriter.println("CAMlog(VM) - the logically flavored Categorical Abstract Machine");
                ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
                Object object = objectInputStream.readObject();
                boolean bl = options.check("det");
                if (bl) {
                    STDrun.random$ = new Random(123456789L);
                }
                Object object2 = DOM.tuple(UTL.split(options.value("arg"), ','));
                if (object instanceof CCC.Combinator) {
                    String string;
                    Object object3;
                    CCC.Combinator combinator = (CCC.Combinator)object;
                    printWriter.println("\nLOADED CCC BINARY");
                    System.gc();
                    long l = System.currentTimeMillis();
                    try {
                        object3 = combinator.eval(null);
                    }
                    catch (CCC.GlobalFailure globalFailure) {
                        object3 = "GLOBAL FAILURE";
                    }
                    StringBuffer stringBuffer = new StringBuffer().append("\nCCC COMBINATOR EVALUATION / STRICT BETA REDUCTION");
                    if (!bl) {
                        long l2 = l;
                        l = System.currentTimeMillis();
                        string = " (" + -(l2 - l) + "ms)";
                    } else {
                        string = "";
                    }
                    printWriter.println(stringBuffer.append(string).append(":\n   ").append(object3).toString());
                    break block18;
                }
                if (object instanceof DOM.Applicable) {
                    String string;
                    DOM.Applicable applicable = (DOM.Applicable)object;
                    printWriter.println("\nLOADED BINARY " + applicable.getClass().getName());
                    System.gc();
                    long l = System.currentTimeMillis();
                    Object object4 = applicable.invoke(object2);
                    StringBuffer stringBuffer = new StringBuffer().append("\nCLOSURE EVALUATION / STRICT BETA REDUCTION");
                    if (!bl) {
                        long l3 = l;
                        l = System.currentTimeMillis();
                        string = " (" + -(l3 - l) + "ms)";
                    } else {
                        string = "";
                    }
                    printWriter.println(stringBuffer.append(string).append(":\n   ").append(object4 != null ? object4 : "GLOBAL FAILURE").toString());
                } else if (object instanceof CAM) {
                    String string;
                    CAM cAM = (CAM)object;
                    cAM.errout = printWriter;
                    CAM.Closure closure = (CAM.Closure)objectInputStream.readObject();
                    printWriter.println("\nLOADED CAM BINARY" + (bl ? "" : ".. " + cAM + " / " + cAM.timestamp));
                    System.gc();
                    long l = System.currentTimeMillis();
                    Object object5 = options.check("dbg") ? closure.debug(object2) : closure.invoke(object2);
                    StringBuffer stringBuffer = new StringBuffer().append("\nCAM EXECUTION / STRICT BETA REDUCTION");
                    if (!bl) {
                        long l4 = l;
                        l = System.currentTimeMillis();
                        string = " (" + -(l4 - l) + "ms)";
                    } else {
                        string = "";
                    }
                    printWriter.println(stringBuffer.append(string).append(":\n   ").append(object5 != null ? object5 : "GLOBAL FAILURE").toString());
                    if (options.check("dmp")) {
                        printWriter.println("\nCAM MEMORY DUMP:");
                        cAM.dumpROM();
                        cAM.dumpRAM();
                    }
                } else {
                    printWriter.println("\nBYTECODE UNKNOWN TO CAMlog VIRTUAL MACHINE...\n   " + object.getClass() + "\n   '" + object + "'");
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                printWriter.println("FATAL ERROR LOADING CAMlog BINARY...\n" + classNotFoundException);
            }
            catch (InvalidClassException invalidClassException) {
                printWriter.println("FATAL ERROR LOADING CAMlog BINARY...\n" + invalidClassException);
            }
        }
        printWriter.println("\n=END CAMlog=");
        printWriter.flush();
    }
}

